package com.lhstack.tomcat;

import org.apache.catalina.Context;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.websocket.server.WsSci;

import java.util.Collections;

public class TomcatApplication {
    public static void main(String[] args) throws Throwable {
        Tomcat tomcat = new Tomcat();
        //2025-02-15新增 新增webapp,指定路径
        Context context = tomcat.addWebapp("", System.getProperty("user.dir") + "/webapp");
        //2025-02-15 添加websocket支持和websocket连接监听器
        context.addServletContainerInitializer(new WsSci(), Collections.singleton(WebSocketListener.class));
        Connector connector = tomcat.getConnector();
        connector.setPort(8080);
        tomcat.start();
        tomcat.getServer().await();
    }
}
