package com.lhstack.tomcat;


import jakarta.websocket.*;
import jakarta.websocket.server.ServerEndpoint;

@ServerEndpoint(value = "/ws")
public class WebSocketListener {


    @OnOpen
    public void onOpen(Session session){
        System.out.println("客户端上线: " + session.getId());
    }

    @OnClose
    public void onClose(Session session){
        System.out.println("客户端下线: " + session.getId());
    }

    @OnError
    public void onError(Session session,Throwable e){
        System.out.println("连接异常: " + session.getId() + ",error: " + e.getMessage());
    }

    @OnMessage
    public void onMessage(String msg,Session session){
        System.out.println("收到客户端: " + session.getId() + ",发送的消息: " + msg);
    }
}
