package com.lhstack.tomcat.controller;

import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.HandlerMethodValidationException;

import java.util.Map;
import java.util.stream.Collectors;

@RestControllerAdvice
public class GlobalExceptionHandlers {


    @ExceptionHandler(exception = MethodArgumentNotValidException.class)
    public Map<String, Object> validatorExceptionHandler(MethodArgumentNotValidException e) {
        Map<String, String> errors = e.getBindingResult().getAllErrors().stream()
                .collect(Collectors.toMap(ObjectError::getObjectName, ObjectError::getDefaultMessage, (o1, o2) -> o2));
        return Map.of("code", "500", "msg", "校验异常", "errors", errors);
    }

    @ExceptionHandler(exception = HandlerMethodValidationException.class)
    public Map<String, Object> exceptionHandler(HandlerMethodValidationException e) {
        Map<Object, String> errors = e.getParameterValidationResults().stream()
                .collect(Collectors.toMap(item -> item.getMethodParameter().getParameterName(),
                        item -> item.getResolvableErrors().stream().map(MessageSourceResolvable::getDefaultMessage)
                                .collect(Collectors.joining(",")), (o1, o2) -> o2));
        return Map.of("code", "500", "msg", "校验异常", "errors", errors);
    }
}
