package com.lhstack.tomcat.controller;

import jakarta.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@RestController
@RequestMapping("test")
public class TestController {

    private static final Logger LOGGER = LoggerFactory.getLogger(TestController.class);

    @GetMapping
    public Map<String,String> test(@RequestParam(name = "value") @NotEmpty(message = "value不能为空") String value){
        LOGGER.info("test: {}",value);
        return Map.of("msg","hello world");
    }
}
