package com.lhstack.tomcat;

import jakarta.servlet.*;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;

import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class TomcatApplication {
    public static void main(String[] args) throws Throwable {
        Tomcat tomcat = new Tomcat();
        Context context = tomcat.addContext("", null);
        //添加Servlet
        Wrapper wrapper = Tomcat.addServlet(context, "main", new HttpServlet() {
            @Override
            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.setHeader("Content-Type", "text/plain;charset=UTF-8");
                resp.getWriter().println("hello world");
            }
        });
        wrapper.setAsyncSupported(true);
        wrapper.addMapping("/");
        FilterDef characterEncodingFilterDef = new FilterDef();
        characterEncodingFilterDef.setAsyncSupported("true");
        characterEncodingFilterDef.setFilterName("CharacterEncodingFilter");
        characterEncodingFilterDef.setFilter(new GenericFilter() {
            @Override
            public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
                req.setCharacterEncoding(StandardCharsets.UTF_8);
                res.setCharacterEncoding(StandardCharsets.UTF_8);
                chain.doFilter(req,res);
            }
        });
        context.addFilterDef(characterEncodingFilterDef);
        FilterMap characterEncodingFilterMap = new FilterMap();
        characterEncodingFilterMap.addURLPattern("/*");
        characterEncodingFilterMap.setFilterName("CharacterEncodingFilter");
        context.addFilterMap(characterEncodingFilterMap);
        Connector connector = tomcat.getConnector();
        connector.setPort(8080);
        tomcat.start();
        tomcat.getServer().await();
    }
}
